/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa.eventlog;

import filenet.vw.apps.taskman.VWTaskTabPanel;
import filenet.vw.apps.taskman.pa.PANode;
import filenet.vw.apps.taskman.pa.eventlog.EventLogConfigPanel;
import filenet.vw.apps.taskman.pa.resources.VWResource;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class EventLogMainPanel
extends VWToolbarBorder {
    JRadioButton m_processAllEventsRadio = null;
    JRadioButton m_processSpecificEventsRadio = null;
    EventLogConfigPanel m_eventLogConfigPanel = null;
    PANode m_node = null;
    boolean m_bPartitioned = false;

    public EventLogMainPanel(PANode node) {
        super(VWResource.EventLogConfiguration, 0, new VWTaskTabPanel(new GridBagLayout()));
        this.m_node = node;
        JPanel panel = this.getClientPanel();
        ButtonGroup bg = new ButtonGroup();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.gridwidth = 1;
        c.insets = new Insets(5, 15, 0, 5);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_processAllEventsRadio = new JRadioButton(VWResource.ProcessAllEvents);
        bg.add(this.m_processAllEventsRadio);
        this.m_processAllEventsRadio.setBorder(null);
        this.m_processAllEventsRadio.setSelected(true);
        this.m_processAllEventsRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EventLogMainPanel.this.updateEventLogConfigState();
            }
        });
        panel.add((Component)this.m_processAllEventsRadio, c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add(Box.createHorizontalStrut(0), c);
        c.insets = new Insets(5, 15, 0, 5);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_processSpecificEventsRadio = new JRadioButton(VWResource.ProcessSpecificEvents);
        bg.add(this.m_processSpecificEventsRadio);
        this.m_processSpecificEventsRadio.setBorder(null);
        this.m_processSpecificEventsRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EventLogMainPanel.this.updateEventLogConfigState();
            }
        });
        panel.add((Component)this.m_processSpecificEventsRadio, c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add(Box.createHorizontalStrut(0), c);
        c.insets = new Insets(7, 15, 15, 100);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        this.m_eventLogConfigPanel = new EventLogConfigPanel(this.m_node);
        panel.add((Component)this.m_eventLogConfigPanel, c);
    }

    public void refresh() {
        boolean started = this.m_node.isStarted();
        this.m_processAllEventsRadio.setEnabled(!this.m_bPartitioned && !started);
        this.m_processSpecificEventsRadio.setEnabled(!started);
        this.m_eventLogConfigPanel.setEnabled(!started);
    }

    public boolean applyProperties() throws Exception {
        if (this.m_processSpecificEventsRadio.isSelected()) {
            if (!this.m_eventLogConfigPanel.applyProperties()) {
                return false;
            }
            this.m_processAllEventsRadio.setEnabled(false);
            this.m_bPartitioned = this.m_node.getPANonRMI().isPAPEPartitionEnabled();
        }
        return true;
    }

    public void resetProperties() {
        try {
            this.m_bPartitioned = this.m_node.getPANonRMI().isPAPEPartitionEnabled();
            this.m_processSpecificEventsRadio.setSelected(this.m_bPartitioned);
            this.m_processAllEventsRadio.setSelected(!this.m_bPartitioned);
            this.m_eventLogConfigPanel.resetProperties(this.m_bPartitioned);
            this.refresh();
        }
        catch (Exception e) {
            this.m_node.displayError(e);
        }
    }

    private void updateEventLogConfigState() {
        try {
            this.m_eventLogConfigPanel.resetProperties(this.m_processSpecificEventsRadio.isSelected());
        }
        catch (Exception e) {
            this.m_node.displayError(e);
        }
    }
}

